//
//  ErtcHelper.m
//  EZOpenSDKDemo
//
//  Created by JuneCheng on 2025/4/22.
//  Copyright © 2025 hikvision. All rights reserved.
//

#import "ErtcHelper.h"

@implementation ErtcHelper

+ (instancetype)sharedInstance {
    static ErtcHelper *_sharedInstance = nil;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        _sharedInstance = [[ErtcHelper alloc] init];
        
    });
    return _sharedInstance;
}


+ (void)initERTCEngine:(NSString *)appId initBlock:(InstanceBlock)initBlock {
    [[ERTCLog sharedInstance] enableFileLog];// 打开文件log
    [[ERTCLog sharedInstance] enableConsoleLog];// 打开控制台log
    ERTCEngineConfig *config = [[ERTCEngineConfig alloc] init];
    config.apiUrl = [kUserDefaults objectForKey:UserApiUrl];// 指定域名
    config.appID = appId;
    
    [ERTCEngine createWithConfig:config instanceBlock:initBlock];
}

@end
