package ezviz.ezopensdkcommon.bandwidthcheck;

import static ezviz.ezopensdkcommon.bandwidthcheck.BWCSpeedTestInputActivity.EXTRA_BWCHECK_TYPE;
import static ezviz.ezopensdkcommon.demo.DemoConfig.SP_BWCHECK_RESULT;
import static ezviz.ezopensdkcommon.demo.DemoConfig.SP_BWCHECK_RESULT_CLIENT;
import static ezviz.ezopensdkcommon.demo.DemoConfig.SP_BWCHECK_RESULT_DEVICE;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.videogo.bandwidthcheck.EZBWCheckResult;
import com.videogo.openapi.EZConstants;

import java.util.ArrayList;
import java.util.List;

import ezviz.ezopensdkcommon.R;
import ezviz.ezopensdkcommon.common.RootActivity;
import ezviz.ezopensdkcommon.common.TitleBar;

public class BWCSpeedTestNetRecordActivity extends RootActivity {

    private static final String TAG = BWCSpeedTestNetRecordActivity.class.getSimpleName();

    private ListView listView;
    private LinearLayout noDataLL;

    private List<EZBWCheckResult> bwCheckResultList;
    private EZBWCheckNetRecordAdapter recordAdapter;

    // region ------------------------------ 数据传递 ------------------------------

    private int bwCheckType;

    // endregion

    public static void launch(Context context, int bwCheckType) {
        Intent intent = new Intent(context, BWCSpeedTestNetRecordActivity.class);
        intent.putExtra(EXTRA_BWCHECK_TYPE, bwCheckType);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_bwc_speed_test_net_record);
        initTitleBar();
        initUI();
        initData();
    }

    private void initTitleBar() {
        TitleBar mTitleBar = findViewById(R.id.title_bar);
        mTitleBar.setTitle("测速记录");
        mTitleBar.addBackButton(v -> onBackPressed());
        mTitleBar.setBackgroundColor(getResources().getColor(R.color.transparent));
    }

    private void initData() {
        Intent intent = getIntent();
        bwCheckType = intent.getIntExtra(EXTRA_BWCHECK_TYPE, 1);

        String bcCheckResultKey = bwCheckType == EZConstants.EZBWCheckType.EZBWCheckClientUpward ?
                SP_BWCHECK_RESULT_DEVICE : SP_BWCHECK_RESULT_CLIENT;
        SharedPreferences sp = getSharedPreferences(SP_BWCHECK_RESULT, Context.MODE_PRIVATE);
        String resultsString = sp.getString(bcCheckResultKey, "");
        Gson gson = new Gson();
        bwCheckResultList = gson.fromJson(resultsString, new TypeToken<List<EZBWCheckResult>>() {
        }.getType());
        if (bwCheckResultList == null) {
            noDataLL.setVisibility(View.VISIBLE);
        } else {
            noDataLL.setVisibility(View.GONE);
            recordAdapter.setData(bwCheckResultList);
            recordAdapter.notifyDataSetChanged();
        }
    }

    private void initUI() {
        listView = findViewById(R.id.listView);
        noDataLL = findViewById(R.id.ll_no_data);
        recordAdapter = new EZBWCheckNetRecordAdapter(this);
        listView.setAdapter(recordAdapter);
        listView.setOnItemClickListener((parent, view, position, id) -> BWCSpeedTestResultActivity.launch(BWCSpeedTestNetRecordActivity.this, bwCheckResultList.get(position), false));
    }

    /**
     * Adapter
     */
    private class EZBWCheckNetRecordAdapter extends BaseAdapter {
        protected List<EZBWCheckResult> mData = new ArrayList<>();
        private LayoutInflater inflater;

        public EZBWCheckNetRecordAdapter(Context context) {
            inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        }

        public void setData(List<EZBWCheckResult> list) {
            mData.clear();
            mData.addAll(list);
        }

        @Override
        public int getCount() {
            return mData == null ? 0 : mData.size();
        }

        @Override
        public Object getItem(int position) {
            return mData.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder = null;
            EZBWCheckResult resultInfo = mData.get(position);
            if (convertView == null) {
                viewHolder = new ViewHolder();
                convertView = inflater.inflate(R.layout.item_bwc_speed_test_net_record, parent, false);
                viewHolder.tv_title = (TextView) convertView.findViewById(R.id.text1);
                viewHolder.tv_checkTime = (TextView) convertView.findViewById(R.id.text2);
                convertView.setTag(viewHolder);
            } else {
                viewHolder = (ViewHolder) convertView.getTag();
            }

            viewHolder.tv_title.setText(bwCheckType == EZConstants.EZBWCheckType.EZBWCheckClientUpward ?
                    resultInfo.deviceSerial + "@" + resultInfo.cameraNo : resultInfo.networkName);
            viewHolder.tv_checkTime.setText(resultInfo.checkTime);

            return convertView;
        }

        class ViewHolder {
            TextView tv_title;
            TextView tv_checkTime;
        }
    }
}