package com.videogo.ui.videotalk;

import android.Manifest;
import android.annotation.TargetApi;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;

import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;

import com.ez.baselib.utils.LogUtil;
import com.ez.basertc.RTCConstant;
import com.ez.ertcengine.ERTCEngine;
import com.videogo.EzvizApplication;
import com.videogo.constant.IntentConsts;
import com.videogo.exception.BaseException;
import com.videogo.global.GlobalKit;
import com.videogo.openapi.bean.EZCameraInfo;
import com.videogo.util.LocalInfo;
import com.videogo.widget.TitleBar;

import java.util.ArrayList;
import java.util.List;

import ezviz.ezopensdk.R;
import ezviz.ezopensdkcommon.common.RootActivity;

public class EZJoinMeetingActivity extends RootActivity {

    protected static final String TAG = EZJoinMeetingActivity.class.getSimpleName();

    private EditText appIdEt;
    private EditText ertcTokenEt;
    private EditText ertcHttpTokenEt;
    private EditText roomIdEt;
    private EditText userIdEt;

    private EZCameraInfo mCameraInfo = null;

    private boolean isClientCallDevice;// true:客户端呼叫设备端 false:设备端呼叫，客户端接听

    private boolean isFromPermissionSetting;// true为应用权限管理返回

    // ------------------------------ 生命周期 ------------------------------

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        initData();
        initView();
        if (GlobalKit.isJCTest) {
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (isFromPermissionSetting) {
            checkPermissions();
            isFromPermissionSetting = false;
        }
    }

    // ------------------------------ 点击事件 ------------------------------

    /**
     * 客户端发起视频通话
     */
    public void onClickVideoTalk(View view) {
        if (!checkVideoTalkParams()) {
            return;
        }
        isClientCallDevice = true;
        checkPermissions();
    }

    /**
     * 设备端端发起视频通话后，客户端接听
     */
    public void onClickAnswerDeviceCall(View view) {
        if (!checkVideoTalkParams()) {
            return;
        }
        isClientCallDevice = false;
        checkPermissions();
    }

    /**
     * 设备端端发起视频通话后，客户端拒接
     */
    public void onClickRejectDeviceCall(View view) {
        if (!checkVideoTalkParams()) {
            return;
        }
        new Thread(() -> {
            try {
                boolean ret = EzvizApplication.getOpenSDK().rejectVideoCallReqFromDevice(appIdEt.getText().toString(), ertcHttpTokenEt.getText().toString(),
                        roomIdEt.getText().toString(), mCameraInfo.getDeviceSerial(), mCameraInfo.getCameraNo(), userIdEt.getText().toString());
                if (ret) {
                    showToast("拒接成功");
                }
            } catch (BaseException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void onClickClearEditText(View view) {
        switch (view.getId()) {
            case R.id.btn_appId_clear:
                appIdEt.setText("");
                break;
            case R.id.btn_ertc_token_clear:
                ertcTokenEt.setText("");
                break;
            case R.id.btn_ertc_http_token_clear:
                ertcHttpTokenEt.setText("");
                break;
            case R.id.btn_roomId_clear:
                roomIdEt.setText("");
                break;
            case R.id.btn_userId_clear:
                userIdEt.setText("");
                break;
        }
    }

    private boolean checkVideoTalkParams() {
        String appId = appIdEt.getText().toString();
        String ertcToken = ertcTokenEt.getText().toString();
        String ertcHttpToken = ertcHttpTokenEt.getText().toString();
        String roomId = roomIdEt.getText().toString();
        String userId = userIdEt.getText().toString();
        if (TextUtils.isEmpty(appId) || TextUtils.isEmpty(ertcToken) || TextUtils.isEmpty(ertcHttpToken) || TextUtils.isEmpty(roomId) || TextUtils.isEmpty(userId)) {
            showToast("信息不能为空");
            return false;
        }
        return true;
    }

    // ------------------------------ ERTC初始化 ------------------------------

    private void initErtcEngine() {
        String appId = appIdEt.getText().toString();
        String ertcToken = ertcTokenEt.getText().toString();
        String ertcHttpToken = ertcHttpTokenEt.getText().toString();
        String roomId = roomIdEt.getText().toString();
        String userId = userIdEt.getText().toString();
        ErtcHelper.initERTCEngine(EZJoinMeetingActivity.this, appId, new ERTCEngine.OnInitListener() {
            @Override
            public void onInitialization(ERTCEngine engine) {
                LogUtil.d(TAG, "Init OK");
                ErtcHelper.ertcEngine = engine;

                RTCConstant.EnterParam localUserInfo = new RTCConstant.EnterParam();
                localUserInfo.roomId = roomId;
                localUserInfo.userId = userId;
                localUserInfo.token = ertcToken;
                localUserInfo.appId = appId;

                ErtcRoomActivity.launch(EZJoinMeetingActivity.this, localUserInfo, mCameraInfo, ertcHttpToken,
                        isClientCallDevice,true, true);
            }

            @Override
            public void onError(int code) {
                LogUtil.d(TAG, "Init failed error:" + code);
            }
        });
    }

    // ------------------------------ Data ------------------------------

    private void initData() {
        // 初始化mLocalInfo，记录屏幕尺寸信息
        LocalInfo mLocalInfo = LocalInfo.getInstance();
        DisplayMetrics metric = new DisplayMetrics();
        getWindowManager().getDefaultDisplay().getMetrics(metric);
        if (mLocalInfo != null) {
            mLocalInfo.setScreenWidthHeight(metric.widthPixels, metric.heightPixels);
            mLocalInfo.setNavigationBarHeight((int) Math.ceil(25 * getResources().getDisplayMetrics().density));
        }
        mCameraInfo = getIntent().getParcelableExtra(IntentConsts.EXTRA_CAMERA_INFO);
    }

    // ------------------------------ UI ------------------------------

    private void initView() {
        setContentView(R.layout.activity_join_meeting);
        initTitleBar();

        appIdEt = findViewById(R.id.et_appId);
        ertcTokenEt = findViewById(R.id.et_ertc_token);
        ertcHttpTokenEt = findViewById(R.id.et_ertc_http_token);
        roomIdEt = findViewById(R.id.et_roomId);
        userIdEt = findViewById(R.id.et_userId);
    }

    private void initTitleBar() {
        TitleBar mTitleBar = findViewById(R.id.title_bar);
        mTitleBar.addBackButton(view -> finish());
        mTitleBar.setTitle("视频通话");
    }

    // ------------------------------ 动态权限申请 ------------------------------

    public void checkPermissions() {
        if (Build.VERSION.SDK_INT >= 23) {
            checkAndRequestPermission();
        } else {
            afterHasPermission();
        }
    }

    @TargetApi(Build.VERSION_CODES.M)
    private void checkAndRequestPermission() {
        List<String> lackedPermission = new ArrayList<>();
        if (!(checkSelfPermission(Manifest.permission.CAMERA) == PackageManager.PERMISSION_GRANTED)) {
            lackedPermission.add(Manifest.permission.CAMERA);
        }
        if (!(checkSelfPermission(Manifest.permission.RECORD_AUDIO) == PackageManager.PERMISSION_GRANTED)) {
            lackedPermission.add(Manifest.permission.RECORD_AUDIO);
        }
        // 权限都已经有了
        if (lackedPermission.size() == 0) {
            afterHasPermission();
        } else {
            // 请求所缺少的权限，在onRequestPermissionsResult中再看是否获得权限
            String[] requestPermissions = new String[lackedPermission.size()];
            lackedPermission.toArray(requestPermissions);
            requestPermissions(requestPermissions, 1000);
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1000 && hasAllPermissionsGranted(grantResults)) {
            afterHasPermission();
        } else {
            try {
                showPermissionDialog();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * 权限设置
     */
    private void showPermissionDialog() {
        AlertDialog dialog =
                new AlertDialog.Builder(this).setMessage("应用缺少必要的权限！请点击\"权限\"，打开所需要的权限。").setPositiveButton("去设置",
                        (dialog1, which) -> {
            isFromPermissionSetting = true;
            dialog1.dismiss();
            Intent intent = new Intent(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
            intent.setData(Uri.parse("package:" + getPackageName()));
            startActivity(intent);
        }).setNegativeButton("取消", (dialog12, which) -> {
            dialog12.dismiss();
        }).create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        dialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(ContextCompat.getColor(this, R.color.black));
        // 设置居中，解决Android9.0 AlertDialog不居中问题
        Window dialogWindow = dialog.getWindow();
        WindowManager.LayoutParams p = dialogWindow.getAttributes();
        p.width = (int) (LocalInfo.getInstance().getScreenWidth() * 0.9);
        p.gravity = Gravity.CENTER;
        dialogWindow.setAttributes(p);
    }

    private void afterHasPermission() {
        // 有相机、麦克风权限后，初始化ERTCEngine
        initErtcEngine();
    }

    private boolean hasAllPermissionsGranted(int[] grantResults) {
        for (int grantResult : grantResults) {
            if (grantResult == PackageManager.PERMISSION_DENIED) {
                return false;
            }
        }
        return true;
    }
}