/*
 * 服务器区域枚举类
 * EZOpenSDK
 *
 * Created by junecheng on 2024/3/5.
 * Copyright (c) 2024年 Ezviz. All rights reserved.
 */
export default class ServerAreasEnum {
  static readonly ALL_SERVERS: Array<ServerAreasEnum> = [
  // 国内
    new ServerAreasEnum(0, 'Asia-China(国内)', 'https://open.ys7.com', 'https://openauth.ys7.com', '26810f3acd794862b608b6cfbc32a6b8'),
    // 海外：俄罗斯
    new ServerAreasEnum(5, 'Asia-Russia(海外：俄罗斯)', 'https://irusopen.ezvizru.com', 'https://irusopenauth.ezvizru.com'),
    // 海外：亚洲（服务亚洲的所有国家，但不包括中国和俄罗斯）
    new ServerAreasEnum(10, 'Asia(海外：亚洲，不包括中国和俄罗斯)', 'https://isgpopen.ezvizlife.com', 'https://isgpopenauth.ezvizlife.com'),
    // 海外：北美洲
    new ServerAreasEnum(15, 'North America(海外：北美洲)', 'https://iusopen.ezvizlife.com', 'https://iusopenauth.ezvizlife.com'),
    // 海外：南美洲
    new ServerAreasEnum(20, 'South America(海外：南美洲)', 'https://isaopen.ezvizlife.com', 'https://isaopenauth.ezvizlife.com'),
    // 海外：欧洲
    new ServerAreasEnum(25, 'Europe(海外：欧洲)', 'https://ieuopen.ezvizlife.com', 'https://ieuopenauth.ezvizlife.com', '5cadedf5478d11e7ae26fa163e8bac01'),
    // 自定义域名
    new ServerAreasEnum(26, 'Other(自定义区域)', '', ''),
    // 测试平台:test12
    new ServerAreasEnum(110, 'test12', 'https://test12open.ezv-test.com', 'https://test12openauth.ezv-test.com'),
    // 测试平台:test13
    new ServerAreasEnum(111, 'test13', 'https://test13open.ezv-test.com', 'https://test13openauth.ezv-test.com'),
    // 测试平台:testcn
    new ServerAreasEnum(115, 'testcn', 'https://testcnopen.ezv-test.com', 'https://testcnopenauth.ezv-test.com'),
    // 测试平台:testus
    new ServerAreasEnum(120, 'testus', 'https://testusopen.ezv-test.com', 'https://testusopenauth.ezv-test.com'),
    // 温氏
    new ServerAreasEnum(126, 'WenShi', 'https://ezcpcloudopen.wens.com.cn', 'https://ezcpcloudopenauth.wens.com.cn'),
    // 华住
    new ServerAreasEnum(127, 'HuaZhu', 'https://ezcpatctestopen.ys7.com', 'https://ezcpatctestopenauth.ys7.com')
  ]
  id: number = 0
  areaName: string = ''
  apiUrl: string = ''
  authUrl: string = ''
  defaultOpenAuthAppKey: string = ''

  constructor(id: number, areaName: string, apiUrl: string, authUrl: string, defaultOpenAuthAppKey?: string) {
    this.id = id
    this.areaName = areaName
    this.apiUrl = apiUrl
    this.authUrl = authUrl
    this.defaultOpenAuthAppKey = defaultOpenAuthAppKey ? defaultOpenAuthAppKey : ''
  }

  static getSelectServerArray(): { value: string }[] {
    let selectServerArray: { value: string }[] = []
    for (let index = 0; index < ServerAreasEnum.ALL_SERVERS.length; index++) {
      const serverInfo = ServerAreasEnum.ALL_SERVERS[index]
      selectServerArray.push({ value: serverInfo.areaName })
    }
    return selectServerArray
  }
}

