/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.bandwidthcheck;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.ezviz.bandwidthcheck.BWCSpeedTestActivity;
import com.ezviz.bandwidthcheck.BWCSpeedTestNetRecordActivity;
import com.ezviz.bandwidthcheck.R;
import com.ezviz.common.RootActivity;
import com.ezviz.common.TitleBar;
import com.videogo.openapi.EZConstants;
import com.videogo.util.LogUtil;
import java.util.Locale;

public class BWCSpeedTestInputActivity
extends RootActivity
implements View.OnClickListener {
    private static final String TAG = BWCSpeedTestInputActivity.class.getSimpleName();
    public static final String EXTRA_BWCHECK_TYPE = "EXTRA_BWCHECK_TYPE";
    private ImageView tokenHintIv;
    private EditText tokenEt;
    private ImageButton tokenClearIb;
    private ImageView deviceHintIv;
    private EditText deviceEt;
    private ImageButton deviceClearIb;
    private TextView deviceAsteriskTv;
    private Button startBtn;
    private int bwCheckType;
    private String deviceSerial;
    private int cameraNo;

    public static void launch(Context context, int bwCheckType, String deviceSerial, int cameraNo) {
        Intent intent = new Intent(context, BWCSpeedTestInputActivity.class);
        intent.putExtra(EXTRA_BWCHECK_TYPE, bwCheckType);
        intent.putExtra("com.videogo.EXTRA_DEVICE_ID", deviceSerial);
        intent.putExtra("com.videogo.EXTRA_CAMERA_NO", cameraNo);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_bwc_speed_test_input);
        this.initData();
        this.initTitleBar();
        this.initUI();
        this.initListener();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_start) {
            this.startSpeedTest();
        } else if (v.getId() == R.id.iv_token_hint) {
            this.openHintPopupWindow((View)this.tokenHintIv, "\u8bf7\u81f3open.ys7.com\u767b\u5f55\u63a7\u5236\u53f0\uff0c\u8fdb\u5165[\u4e91\u76f4\u64ad>\u6570\u636e\u76d1\u63a7>\u5e26\u5bbd\u68c0\u6d4b\u5de5\u5177]\uff0c\u8fdb\u884c\u83b7\u53d6");
        } else if (v.getId() == R.id.iv_device_hint) {
            this.openHintPopupWindow((View)this.deviceHintIv, "IPC\u591a\u76ee\u6216NVR\u8bf7\u8f93\u5165\u901a\u9053\u53f7\uff0cIPC\u5355\u76ee\u53ef\u4ee5\u4e0d\u7528\u8f93\u5165\uff0c\u9ed8\u8ba4\u4e3a1\u901a\u9053");
        } else if (v.getId() == R.id.ib_token_clear) {
            this.tokenEt.setText((CharSequence)"");
        } else if (v.getId() == R.id.ib_device_clear) {
            this.deviceEt.setText((CharSequence)"");
            this.deviceSerial = "";
            this.cameraNo = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startSpeedTest() {
        String deviceInfo = this.deviceEt.getText().toString();
        if (!TextUtils.isEmpty((CharSequence)deviceInfo)) {
            if (deviceInfo.contains("@")) {
                String[] deviceInfoArray = deviceInfo.split("@");
                if (deviceInfoArray.length != 2) {
                    this.showToast("\u8bf7\u8f93\u5165\u6b63\u786e\u7684IPC\u8bbe\u5907\u4fe1\u606f");
                    return;
                }
                this.deviceSerial = deviceInfoArray[0];
                try {
                    this.cameraNo = Integer.parseInt(deviceInfoArray[1]);
                }
                catch (NumberFormatException e) {
                    this.showToast("\u8bf7\u8f93\u5165\u6b63\u786e\u7684IPC\u8bbe\u5907\u4fe1\u606f");
                    return;
                }
            } else {
                this.deviceSerial = deviceInfo;
                this.cameraNo = 1;
            }
        }
        LogUtil.i((String)TAG, (String)String.format(Locale.getDefault(), "bwCheckType=%s, token=%s, deviceSerial=%s, cameraNo=%d", this.bwCheckType, this.tokenEt.getText().toString(), this.deviceSerial, this.cameraNo));
        BWCSpeedTestActivity.launch((Context)this, this.bwCheckType, this.tokenEt.getText().toString(), this.deviceSerial, this.cameraNo);
    }

    private void updateStartButtonState(boolean enabled) {
        this.startBtn.setEnabled(enabled);
        int backgroundRes = enabled ? R.drawable.selector_blue_8dp : R.drawable.bg_blue_8dp_disable;
        this.startBtn.setBackground(this.getResources().getDrawable(backgroundRes));
    }

    public void openHintPopupWindow(View parent, String hint) {
        LayoutInflater layoutInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        ViewGroup layoutView = (ViewGroup)layoutInflater.inflate(R.layout.pop_hint, null, true);
        TextView hintTv = (TextView)layoutView.findViewById(R.id.tv_hint);
        hintTv.setText((CharSequence)hint);
        int popupWindowWidth = this.tokenEt.getWidth() - 100;
        PopupWindow popupWindow = new PopupWindow((View)layoutView, popupWindowWidth, -2, true);
        popupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
        popupWindow.setFocusable(false);
        popupWindow.setOutsideTouchable(true);
        popupWindow.showAsDropDown(parent, -popupWindowWidth / 2 + this.tokenHintIv.getWidth() / 2, -10);
        popupWindow.setOnDismissListener(() -> LogUtil.i((String)TAG, (String)"KEYCODE_BACK DOWN"));
        popupWindow.update();
    }

    private void initTitleBar() {
        TitleBar mTitleBar = (TitleBar)this.findViewById(R.id.title_bar);
        mTitleBar.setTitle(this.bwCheckType == EZConstants.EZBWCheckType.EZBWCheckClientUpward ? "\u6a21\u62df\u8bbe\u5907\u5e26\u5bbd\u68c0\u6d4b" : "\u7f51\u7edc\u6d4b\u901f");
        mTitleBar.addBackButton(v -> this.onBackPressed());
        mTitleBar.setBackgroundColor(this.getResources().getColor(R.color.transparent));
        mTitleBar.addRightButton(R.mipmap.ic_bwc_history, v -> BWCSpeedTestNetRecordActivity.launch((Context)this, this.bwCheckType));
    }

    private void initData() {
        Intent intent = this.getIntent();
        this.bwCheckType = intent.getIntExtra(EXTRA_BWCHECK_TYPE, 1);
        this.deviceSerial = intent.getStringExtra("com.videogo.EXTRA_DEVICE_ID");
        this.cameraNo = intent.getIntExtra("com.videogo.EXTRA_CAMERA_NO", 1);
    }

    private void initUI() {
        this.tokenHintIv = (ImageView)this.findViewById(R.id.iv_token_hint);
        this.tokenEt = (EditText)this.findViewById(R.id.et_token);
        this.tokenClearIb = (ImageButton)this.findViewById(R.id.ib_token_clear);
        this.deviceHintIv = (ImageView)this.findViewById(R.id.iv_device_hint);
        this.deviceEt = (EditText)this.findViewById(R.id.et_device);
        this.deviceClearIb = (ImageButton)this.findViewById(R.id.ib_device_clear);
        this.deviceAsteriskTv = (TextView)this.findViewById(R.id.tv_device_asterisk);
        this.startBtn = (Button)this.findViewById(R.id.btn_start);
        if (!TextUtils.isEmpty((CharSequence)this.deviceSerial)) {
            this.deviceEt.setText((CharSequence)(this.deviceSerial + "@" + this.cameraNo));
            this.deviceEt.setEnabled(false);
        }
        boolean isTokenValid = !this.tokenEt.getText().toString().isEmpty();
        boolean isDeviceValid = !TextUtils.isEmpty((CharSequence)this.deviceEt.getText().toString());
        this.tokenClearIb.setVisibility(isTokenValid ? 0 : 8);
        this.deviceClearIb.setVisibility(8);
        if (this.bwCheckType == EZConstants.EZBWCheckType.EZBWCheckClientUpward) {
            this.deviceAsteriskTv.setVisibility(0);
            this.updateStartButtonState(isTokenValid && isDeviceValid);
        } else {
            this.deviceAsteriskTv.setVisibility(8);
            this.updateStartButtonState(isTokenValid);
        }
    }

    private void initListener() {
        this.tokenHintIv.setOnClickListener((View.OnClickListener)this);
        this.deviceHintIv.setOnClickListener((View.OnClickListener)this);
        this.tokenClearIb.setOnClickListener((View.OnClickListener)this);
        this.deviceClearIb.setOnClickListener((View.OnClickListener)this);
        this.startBtn.setOnClickListener((View.OnClickListener)this);
        this.tokenEt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                BWCSpeedTestInputActivity.this.tokenClearIb.setVisibility(s.length() > 0 ? 0 : 8);
                if (BWCSpeedTestInputActivity.this.bwCheckType == EZConstants.EZBWCheckType.EZBWCheckClientUpward) {
                    boolean isTokenValid = s.length() > 0;
                    boolean isDeviceValid = !TextUtils.isEmpty((CharSequence)BWCSpeedTestInputActivity.this.deviceEt.getText().toString());
                    BWCSpeedTestInputActivity.this.updateStartButtonState(isTokenValid && isDeviceValid);
                } else {
                    BWCSpeedTestInputActivity.this.updateStartButtonState(s.length() > 0);
                }
            }
        });
        this.deviceEt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                boolean isTokenValid;
                BWCSpeedTestInputActivity.this.deviceClearIb.setVisibility(s.length() > 0 ? 0 : 8);
                boolean bl = isTokenValid = !TextUtils.isEmpty((CharSequence)BWCSpeedTestInputActivity.this.tokenEt.getText().toString());
                if (BWCSpeedTestInputActivity.this.bwCheckType == EZConstants.EZBWCheckType.EZBWCheckClientUpward) {
                    boolean isDeviceValid = s.length() > 0;
                    BWCSpeedTestInputActivity.this.updateStartButtonState(isTokenValid && isDeviceValid);
                } else {
                    BWCSpeedTestInputActivity.this.updateStartButtonState(isTokenValid);
                }
            }
        });
    }
}

