/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.bandwidthcheck;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import com.ezviz.bandwidthcheck.BWCSpeedTestInputActivity;
import com.ezviz.bandwidthcheck.R;
import com.ezviz.common.RootActivity;
import com.ezviz.common.TitleBar;
import com.videogo.openapi.EZConstants;
import com.videogo.util.LocalInfo;
import java.util.ArrayList;

public class BWCToolSelectActivity
extends RootActivity
implements View.OnClickListener {
    private static final String TAG = BWCToolSelectActivity.class.getSimpleName();
    private RelativeLayout bwcDeviceRL;
    private RelativeLayout bwcNetRL;
    private boolean isFromPermissionSetting;
    private String deviceSerial;
    private int cameraNo;
    private long mLastPressTimeMs = 0L;

    public static void launch(Context context) {
        Intent intent = new Intent(context, BWCToolSelectActivity.class);
        context.startActivity(intent);
    }

    public static void launch(Context context, String deviceSerial, int cameraNo) {
        Intent intent = new Intent(context, BWCToolSelectActivity.class);
        intent.putExtra("com.videogo.EXTRA_DEVICE_ID", deviceSerial);
        intent.putExtra("com.videogo.EXTRA_CAMERA_NO", cameraNo);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_bwc_tool_select);
        this.initData();
        this.initTitleBar();
        this.initUI();
        this.checkPermissions();
    }

    protected void onResume() {
        super.onResume();
        if (this.isFromPermissionSetting) {
            this.checkPermissions();
            this.isFromPermissionSetting = false;
        }
    }

    public void onBackPressed() {
        if (!TextUtils.isEmpty((CharSequence)this.deviceSerial)) {
            this.finish();
        } else {
            this.checkExit();
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.rl_bwc_device) {
            BWCSpeedTestInputActivity.launch((Context)this, EZConstants.EZBWCheckType.EZBWCheckClientUpward, this.deviceSerial, this.cameraNo);
        } else if (id2 == R.id.rl_bwc_net) {
            BWCSpeedTestInputActivity.launch((Context)this, EZConstants.EZBWCheckType.EZBWCheckClientUpward | EZConstants.EZBWCheckType.EZBWCheckClientDownward, this.deviceSerial, this.cameraNo);
        }
    }

    private void checkExit() {
        boolean isExist = false;
        if (this.mLastPressTimeMs > 0L && System.currentTimeMillis() - this.mLastPressTimeMs < 2000L) {
            isExist = true;
        }
        if (isExist) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getApplicationContext().getString(R.string.app_closed), (int)1).show();
            RootActivity.exitApp();
        } else {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)this.getApplicationContext().getString(R.string.press_again_to_exit), (int)0).show();
            this.mLastPressTimeMs = System.currentTimeMillis();
        }
    }

    private void initTitleBar() {
        TitleBar mTitleBar = (TitleBar)this.findViewById(R.id.title_bar);
        mTitleBar.setTitle("\u5e26\u5bbd\u68c0\u6d4b\u5de5\u5177");
        if (!TextUtils.isEmpty((CharSequence)this.deviceSerial)) {
            mTitleBar.addBackButton(v -> this.finish());
        }
        mTitleBar.setBackgroundColor(this.getResources().getColor(R.color.transparent));
    }

    private void initData() {
        Intent intent = this.getIntent();
        this.deviceSerial = intent.getStringExtra("com.videogo.EXTRA_DEVICE_ID");
        this.cameraNo = intent.getIntExtra("com.videogo.EXTRA_CAMERA_NO", 1);
    }

    private void initUI() {
        this.bwcDeviceRL = (RelativeLayout)this.findViewById(R.id.rl_bwc_device);
        this.bwcNetRL = (RelativeLayout)this.findViewById(R.id.rl_bwc_net);
        this.bwcDeviceRL.setOnClickListener((View.OnClickListener)this);
        this.bwcNetRL.setOnClickListener((View.OnClickListener)this);
    }

    public void checkPermissions() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.checkAndRequestPermission();
        } else {
            this.afterHasPermission();
        }
    }

    @TargetApi(value=23)
    private void checkAndRequestPermission() {
        ArrayList<String> lackedPermission = new ArrayList<String>();
        if (this.checkSelfPermission("android.permission.ACCESS_FINE_LOCATION") != 0) {
            lackedPermission.add("android.permission.ACCESS_FINE_LOCATION");
        }
        if (lackedPermission.size() == 0) {
            this.afterHasPermission();
        } else {
            String[] requestPermissions = new String[lackedPermission.size()];
            lackedPermission.toArray(requestPermissions);
            this.requestPermissions(requestPermissions, 1000);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1000 && this.hasAllPermissionsGranted(grantResults)) {
            this.afterHasPermission();
        } else {
            try {
                this.showPermissionDialog();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void showPermissionDialog() {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)"\u5e94\u7528\u7f3a\u5c11\u5fc5\u8981\u7684\u6743\u9650\uff01\u8bf7\u70b9\u51fb\"\u6743\u9650\"\uff0c\u6253\u5f00\u6240\u9700\u8981\u7684\u6743\u9650\u3002").setPositiveButton((CharSequence)"\u53bb\u8bbe\u7f6e", (dialog1, which) -> {
            this.isFromPermissionSetting = true;
            dialog1.dismiss();
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
            this.startActivity(intent);
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", (dialog12, which) -> dialog12.dismiss()).create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        dialog.getButton(-2).setTextColor(ContextCompat.getColor((Context)this, (int)R.color.black));
        Window dialogWindow = dialog.getWindow();
        WindowManager.LayoutParams p = dialogWindow.getAttributes();
        p.width = (int)((double)LocalInfo.getInstance().getScreenWidth() * 0.9);
        p.gravity = 17;
        dialogWindow.setAttributes(p);
    }

    private void afterHasPermission() {
    }

    private boolean hasAllPermissionsGranted(int[] grantResults) {
        for (int grantResult : grantResults) {
            if (grantResult != -1) continue;
            return false;
        }
        return true;
    }
}

