/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.common;

import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.widget.Toast;
import com.videogo.constant.Config;
import com.videogo.util.LogUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static String getNetTypeName(Context context) {
        NetworkInfo curNetwork;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (curNetwork = connectivity.getActiveNetworkInfo()) != null) {
            int nType = curNetwork.getType();
            if (nType == 1) {
                return curNetwork.getTypeName();
            }
            if (nType == 0) {
                return curNetwork.getSubtypeName();
            }
            return "UNKNOWN";
        }
        return "UNKNOWN";
    }

    public static String getNetworkType(Context context) {
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            if (cm == null) {
                return "\u672a\u77e5\u7f51\u7edc";
            }
            NetworkInfo networkInfo = cm.getActiveNetworkInfo();
            if (networkInfo == null || !networkInfo.isConnected()) {
                return "\u672a\u8fde\u63a5\u7f51\u7edc";
            }
            int type = networkInfo.getType();
            if (type == 1) {
                return "Wi-Fi";
            }
            if (type == 0) {
                return Utils.getMobileNetworkType(context);
            }
            return "\u5176\u4ed6\u7f51\u7edc";
        }
        catch (Exception e) {
            LogUtil.e((String)"getNetworkType", (String)("getNetworkType error: " + e.getMessage()));
            return "\u7f51\u7edc\u4fe1\u606f\u83b7\u53d6\u5931\u8d25";
        }
    }

    public static String getMobileNetworkType(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm == null) {
                return "\u79fb\u52a8\u7f51\u7edc";
            }
            int networkType = tm.getNetworkType();
            switch (networkType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: {
                    return "2G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 13: {
                    return "4G";
                }
                case 20: {
                    return "5G";
                }
            }
            return "\u79fb\u52a8\u7f51\u7edc";
        }
        catch (Exception e) {
            LogUtil.e((String)"getMobileNetworkType", (String)("getMobileNetworkType error: " + e.getMessage()));
            return "\u79fb\u52a8\u7f51\u7edc";
        }
    }

    public static String getCarrierName(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm == null) {
                return "\u672a\u77e5\u8fd0\u8425\u5546";
            }
            String simOperator = tm.getSimOperator();
            if (simOperator != null) {
                switch (simOperator) {
                    case "46000": 
                    case "46002": 
                    case "46007": {
                        return "\u4e2d\u56fd\u79fb\u52a8";
                    }
                    case "46001": 
                    case "46006": {
                        return "\u4e2d\u56fd\u8054\u901a";
                    }
                    case "46003": 
                    case "46005": 
                    case "46011": {
                        return "\u4e2d\u56fd\u7535\u4fe1";
                    }
                    case "46004": {
                        return "\u4e2d\u56fd\u536b\u901a";
                    }
                    case "46020": {
                        return "\u4e2d\u56fd\u94c1\u901a";
                    }
                }
                return Utils.getCarrierNameByNetwork(tm);
            }
            return Utils.getCarrierNameByNetwork(tm);
        }
        catch (Exception e) {
            LogUtil.e((String)"getCarrierName", (String)("getCarrierName error: " + e.getMessage()));
            return "\u8fd0\u8425\u5546\u4fe1\u606f\u83b7\u53d6\u5931\u8d25";
        }
    }

    public static String getCarrierNameByNetwork(TelephonyManager tm) {
        try {
            String networkOperator = tm.getNetworkOperatorName();
            if (!TextUtils.isEmpty((CharSequence)networkOperator)) {
                if (networkOperator.contains("\u79fb\u52a8") || networkOperator.contains("China Mobile")) {
                    return "\u4e2d\u56fd\u79fb\u52a8";
                }
                if (networkOperator.contains("\u8054\u901a") || networkOperator.contains("China Unicom")) {
                    return "\u4e2d\u56fd\u8054\u901a";
                }
                if (networkOperator.contains("\u7535\u4fe1") || networkOperator.contains("China Telecom")) {
                    return "\u4e2d\u56fd\u7535\u4fe1";
                }
                return networkOperator;
            }
            return "\u672a\u77e5\u8fd0\u8425\u5546";
        }
        catch (Exception e) {
            return "\u672a\u77e5\u8fd0\u8425\u5546";
        }
    }

    public static String getVersionName(Context context) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packInfo = null;
        try {
            packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "UNKNOWN";
        }
    }

    public static void showToast(Context context, String text) {
        if (context == null) {
            return;
        }
        if (text != null && !text.equals("")) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)text, (int)1);
            toast.setGravity(17, 0, 0);
            try {
                toast.show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void showToast(Context context, int id2, int errCode) {
        if (context == null) {
            return;
        }
        String text = context.getString(id2);
        if (errCode != 0) {
            text = text + " (" + errCode + ")";
        }
        if (text != null && !text.equals("")) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)text, (int)1);
            toast.setGravity(17, 0, 0);
            try {
                toast.show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void showToast(Context context, int id2) {
        if (context == null) {
            return;
        }
        String text = context.getString(id2);
        if (text != null && !text.equals("")) {
            Toast toast = Toast.makeText((Context)context, (CharSequence)text, (int)1);
            toast.setGravity(17, 0, 0);
            try {
                toast.show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getErrorTip(Context context, int id2, int errCode) {
        StringBuffer errorTip = new StringBuffer();
        errorTip.append(context.getString(id2));
        if (errCode != 0) {
            errorTip.append(" (").append(errCode).append(")");
        }
        return errorTip.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCPUSerial() {
        String str = "";
        String strCPU = "";
        String cpuAddress = "0000000000000000";
        Process pp = null;
        InputStreamReader ir = null;
        BufferedReader input = null;
        try {
            pp = Runtime.getRuntime().exec("cat /proc/cpuinfo");
            ir = new InputStreamReader(pp.getInputStream());
            input = new LineNumberReader(ir);
            for (int i = 1; i < 100 && (str = ((LineNumberReader)input).readLine()) != null; ++i) {
                if (str.indexOf("serial") <= -1) continue;
                strCPU = TextUtils.substring((CharSequence)str, (int)(str.indexOf(":") + 1), (int)str.length());
                cpuAddress = strCPU.trim();
                break;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                input = null;
            }
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                ir = null;
            }
            if (pp != null) {
                pp.destroy();
                pp = null;
            }
        }
        return cpuAddress;
    }

    public static String getAndroidID(Context context) {
        String androidID = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        LogUtil.d((String)"androidid", (String)androidID);
        return androidID;
    }

    public static void clearAllNotification(Context context) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStreamToString(InputStream is) {
        BufferedReader in = null;
        StringBuffer buffer = new StringBuffer();
        String line = "";
        try {
            in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                buffer.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                in = null;
            }
        }
        return buffer.toString();
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dip(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static void showLog(Context context, String content) {
        if (Config.LOGGING) {
            try {
                Toast.makeText((Context)context, (CharSequence)content, (int)1).show();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static long get19TimeInMillis(String createTime) {
        Calendar calendar = Utils.convert19Calender(createTime);
        return calendar != null ? calendar.getTimeInMillis() : 0L;
    }

    public static Calendar convert14Calender(String stringTime) {
        if (stringTime == null || stringTime.length() < 14 || !Utils.isNumeric(stringTime)) {
            return null;
        }
        String year = stringTime.substring(0, 4);
        String month = stringTime.substring(4, 6);
        String day = stringTime.substring(6, 8);
        String hour = stringTime.substring(8, 10);
        String minute = stringTime.substring(10, 12);
        String second = stringTime.substring(12, 14);
        try {
            GregorianCalendar calendar = new GregorianCalendar(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second));
            return calendar;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Calendar convert16Calender(String szStartTime) {
        if (szStartTime == null || szStartTime.length() < 15) {
            return null;
        }
        String year = szStartTime.substring(0, 4);
        String month = szStartTime.substring(4, 6);
        String day = szStartTime.substring(6, 8);
        String hour = szStartTime.substring(9, 11);
        String minute = szStartTime.substring(11, 13);
        String second = szStartTime.substring(13, 15);
        try {
            GregorianCalendar calendar = new GregorianCalendar(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer.parseInt(day), Integer.parseInt(hour), Integer.parseInt(minute), Integer.parseInt(second));
            return calendar;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Calendar convert19Calender(String createTime) {
        if (createTime == null || createTime.length() < 19) {
            return null;
        }
        try {
            int year = Integer.parseInt(createTime.substring(0, 4));
            int month = Integer.parseInt(createTime.substring(5, 7));
            int day = Integer.parseInt(createTime.substring(8, 10));
            int hourOfDay = Integer.parseInt(createTime.substring(11, 13));
            int minute = Integer.parseInt(createTime.substring(14, 16));
            int second = Integer.parseInt(createTime.substring(17, 19));
            GregorianCalendar calendar = new GregorianCalendar(year, month - 1, day, hourOfDay, minute, second);
            return calendar;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    private static String trimSpaces(String IP) {
        while (IP.startsWith(" ")) {
            IP = IP.substring(1, IP.length()).trim();
        }
        while (IP.endsWith(" ")) {
            IP = IP.substring(0, IP.length() - 1).trim();
        }
        return IP;
    }

    public static boolean isIp(String IP) {
        String[] s;
        if (IP == null || IP.isEmpty()) {
            return false;
        }
        boolean b = false;
        if ((IP = Utils.trimSpaces(IP)).matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}") && Integer.parseInt((s = IP.split("\\."))[0]) < 255 && Integer.parseInt(s[1]) < 255 && Integer.parseInt(s[2]) < 255 && Integer.parseInt(s[3]) < 255) {
            b = true;
        }
        return b;
    }

    public static Bitmap getImageFromAssetsFile(Context context, String fileName) {
        Bitmap image = null;
        AssetManager am = context.getResources().getAssets();
        try {
            InputStream is = am.open(fileName);
            image = BitmapFactory.decodeStream((InputStream)is);
            is.close();
        }
        catch (IOException e) {
            LogUtil.printErrStackTrace((String)"getImageFromAssetsFile", (Throwable)e.fillInStackTrace());
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Drawable getDrawableFromAssetsFile(Context context, String fileName) {
        Bitmap image = null;
        AssetManager am = context.getResources().getAssets();
        InputStream is = null;
        try {
            is = am.open(fileName);
            image = BitmapFactory.decodeStream((InputStream)is);
            is.close();
            is = null;
        }
        catch (IOException e) {
            LogUtil.printErrStackTrace((String)"getDrawableFromAssetsFile", (Throwable)e.fillInStackTrace());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                is = null;
            }
        }
        if (image != null) {
            byte[] chunk = image.getNinePatchChunk();
            if (chunk != null) {
                boolean result = NinePatch.isNinePatchChunk((byte[])chunk);
                NinePatchDrawable patchy = new NinePatchDrawable(image, chunk, new Rect(), null);
                return patchy;
            }
            return new BitmapDrawable(image);
        }
        return null;
    }

    public static StateListDrawable newSelector(Context context, Drawable normal, Drawable pressed, Drawable focused, Drawable unable) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(new int[]{16842919, 16842910}, pressed);
        bg.addState(new int[]{16842910, 16842908}, focused);
        bg.addState(new int[]{16842910}, normal);
        bg.addState(new int[]{16842908}, focused);
        bg.addState(new int[]{16842909}, unable);
        bg.addState(new int[0], normal);
        return bg;
    }

    public static ColorStateList createColorStateList(int normal, int pressed, int focused, int unable) {
        int[] colors = new int[]{pressed, focused, normal, focused, unable, normal};
        int[][] states = new int[][]{{16842919, 16842910}, {16842910, 16842908}, {16842910}, {16842908}, {16842909}, new int[0]};
        ColorStateList colorList = new ColorStateList((int[][])states, colors);
        return colorList;
    }

    public static String getUrlValue(String url, String startStr, String endStr) {
        int endIndex;
        if (url == null || startStr == null) {
            return null;
        }
        int startIndex = url.indexOf(startStr);
        if (startIndex < 0) {
            return null;
        }
        int n = endIndex = endStr != null ? url.indexOf(endStr, startIndex) : url.length();
        if (startIndex >= endIndex) {
            endIndex = url.length();
        }
        try {
            return url.substring(startIndex + startStr.length(), endIndex);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseTestConfigFile(String filePath, Map<String, String> map) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filePath));
            String lineStr = br.readLine();
            while (lineStr != null) {
                String[] values = lineStr.split("\\$");
                if (values.length == 2) {
                    map.put(values[0], values[1]);
                }
                lineStr = br.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isEZOpenProtocol(String url) {
        return url.startsWith("ezopen://");
    }

    private static Map<String, String[]> getParamsMap(String queryString, String enc) {
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        if (queryString != null && queryString.length() > 0) {
            int ampersandIndex;
            int lastAmpersandIndex = 0;
            do {
                String[] newValues;
                String subStr;
                if ((ampersandIndex = queryString.indexOf(38, lastAmpersandIndex) + 1) > 0) {
                    subStr = queryString.substring(lastAmpersandIndex, ampersandIndex - 1);
                    lastAmpersandIndex = ampersandIndex;
                } else {
                    subStr = queryString.substring(lastAmpersandIndex);
                }
                String[] paramPair = subStr.split("=");
                String param = paramPair[0];
                String value = paramPair.length == 1 ? "" : paramPair[1];
                try {
                    value = URLDecoder.decode(value, enc);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (paramsMap.containsKey(param)) {
                    String[] values = (String[])paramsMap.get(param);
                    int len = values.length;
                    newValues = new String[len + 1];
                    System.arraycopy(values, 0, newValues, 0, len);
                    newValues[len] = value;
                } else {
                    newValues = new String[]{value};
                }
                paramsMap.put(param, newValues);
            } while (ampersandIndex > 0);
        }
        return paramsMap;
    }

    public static String getFileNameByUrl(String url) {
        String name = null;
        if (url != null) {
            int start = url.lastIndexOf("/");
            int end = url.lastIndexOf("?");
            name = url.substring(start == -1 ? 0 : start + 1, end == -1 ? url.length() : end);
        }
        return name;
    }
}

