/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import android.util.Log;
import com.bumptech.glide.disklrucache.DiskLruCache;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.DiskCacheWriteLocker;
import com.bumptech.glide.load.engine.cache.SafeKeyGenerator;
import java.io.File;
import java.io.IOException;

public class DiskLruCacheWrapper
implements DiskCache {
    private static final String TAG = "DiskLruCacheWrapper";
    private static final int APP_VERSION = 1;
    private static final int VALUE_COUNT = 1;
    private static DiskLruCacheWrapper wrapper = null;
    private final DiskCacheWriteLocker writeLocker = new DiskCacheWriteLocker();
    private final SafeKeyGenerator safeKeyGenerator;
    private final File directory;
    private final int maxSize;
    private DiskLruCache diskLruCache;

    public static synchronized DiskCache get(File directory, int maxSize) {
        if (wrapper == null) {
            wrapper = new DiskLruCacheWrapper(directory, maxSize);
        }
        return wrapper;
    }

    protected DiskLruCacheWrapper(File directory, int maxSize) {
        this.directory = directory;
        this.maxSize = maxSize;
        this.safeKeyGenerator = new SafeKeyGenerator();
    }

    private synchronized DiskLruCache getDiskCache() throws IOException {
        if (this.diskLruCache == null) {
            this.diskLruCache = DiskLruCache.open(this.directory, 1, 1, this.maxSize);
        }
        return this.diskLruCache;
    }

    private synchronized void resetDiskCache() {
        this.diskLruCache = null;
    }

    @Override
    public File get(Key key) {
        File result;
        block3: {
            String safeKey = this.safeKeyGenerator.getSafeKey(key);
            result = null;
            try {
                DiskLruCache.Value value = this.getDiskCache().get(safeKey);
                if (value != null) {
                    result = value.getFile(0);
                }
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block3;
                Log.w((String)TAG, (String)"Unable to get from disk cache", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Key key, DiskCache.Writer writer) {
        block10: {
            String safeKey = this.safeKeyGenerator.getSafeKey(key);
            this.writeLocker.acquire(key);
            try {
                DiskLruCache.Editor editor = this.getDiskCache().edit(safeKey);
                if (editor == null) break block10;
                try {
                    File file = editor.getFile(0);
                    if (writer.write(file)) {
                        editor.commit();
                    }
                }
                finally {
                    editor.abortUnlessCommitted();
                }
            }
            catch (IOException e) {
                if (Log.isLoggable((String)TAG, (int)5)) {
                    Log.w((String)TAG, (String)"Unable to put to disk cache", (Throwable)e);
                }
            }
            finally {
                this.writeLocker.release(key);
            }
        }
    }

    @Override
    public void delete(Key key) {
        block2: {
            String safeKey = this.safeKeyGenerator.getSafeKey(key);
            try {
                this.getDiskCache().remove(safeKey);
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block2;
                Log.w((String)TAG, (String)"Unable to delete from disk cache", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized void clear() {
        block2: {
            try {
                this.getDiskCache().delete();
                this.resetDiskCache();
            }
            catch (IOException e) {
                if (!Log.isLoggable((String)TAG, (int)5)) break block2;
                Log.w((String)TAG, (String)"Unable to clear disk cache", (Throwable)e);
            }
        }
    }
}

