/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.wifi.configuration;

import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;

public class BaseUtil {
    public static String getMaskIpAddress(Context ctx) {
        WifiManager wifi_service = (WifiManager)ctx.getSystemService("wifi");
        DhcpInfo dhcpInfo = wifi_service.getDhcpInfo();
        int gateway = dhcpInfo.gateway;
        String long2ip = BaseUtil.long2ip(gateway);
        return long2ip;
    }

    public static String getWifiSSID(Context ctx) {
        WifiManager wifi_service = (WifiManager)ctx.getSystemService("wifi");
        WifiInfo connectionInfo = wifi_service.getConnectionInfo();
        String ssid = connectionInfo.getSSID();
        if (Build.VERSION.SDK_INT >= 17 && ssid.startsWith("\"") && ssid.endsWith("\"")) {
            ssid = ssid.substring(1, ssid.length() - 1);
        }
        return ssid;
    }

    public static String long2ip(long ip) {
        int[] b = new int[]{(int)(ip >> 24 & 0xFFL), (int)(ip >> 16 & 0xFFL), (int)(ip >> 8 & 0xFFL), (int)(ip & 0xFFL)};
        String x = String.valueOf(Integer.toString(b[3])) + "." + Integer.toString(b[2]) + "." + Integer.toString(b[1]) + "." + Integer.toString(b[0]);
        return x;
    }

    public static List<Integer> getDataLength(String data, int offset, int after15Offset) {
        if (data == null || data.length() == 0) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        int length = data.length();
        int nFactor = 0;
        int nLastValue = 0;
        int i = 0;
        while (i < length) {
            int realOffset = offset;
            if (i >= 16) {
                realOffset = after15Offset;
            }
            char ascii = data.charAt(i);
            int hValue1 = (ascii & 0xF0) / 16;
            int lValue1 = ascii & 0xF;
            int hValue2 = nFactor ^ nLastValue;
            int lValue2 = hValue1;
            int nValue = hValue2 * 16 + lValue2 + realOffset;
            ++nFactor;
            nLastValue = hValue1;
            result.add(nValue);
            hValue2 = (nFactor %= 16) ^ nLastValue;
            lValue2 = lValue1;
            nValue = hValue2 * 16 + lValue2 + realOffset;
            ++nFactor;
            nFactor %= 16;
            nLastValue = lValue1;
            result.add(nValue);
            ++i;
        }
        return result;
    }
}

