/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.wifi.configuration;

import android.content.Context;
import android.util.Log;
import com.hikvision.wifi.UdpClient.UdpClient;
import com.hikvision.wifi.configuration.BonjorManage;
import com.hikvision.wifi.configuration.DeviceDiscoveryListener;

public class OneStepWifiConfigurationManager {
    private static final String TAG = "OneStepWifiConfigurationManager";
    public static final int HAS_SENDING = 1;
    public static final int START_SUCESS = 2;
    public static final int PARAM_ERROR = 3;
    private Context context = null;
    private String maskIpAddress = null;
    private UdpClient udpClient = null;
    private boolean stop = true;
    private BonjorManage bonjorManage;

    public OneStepWifiConfigurationManager(Context context, String maskIpAddress) {
        this.context = context;
        this.maskIpAddress = maskIpAddress;
    }

    public int startConfig(final String ssidStr, String keyStr, final int seprator, final int frequency, final int packInterval, final int time1, final int time2, final int time3, final int time4, final int waitTime1, final int waitTime2, final int waitTime3, final int waitTime4) {
        if (!this.stop) {
            this.stopConfig();
        }
        Log.d((String)TAG, (String)("startSendConfigData : ssidStr:" + ssidStr + " keyStr:" + keyStr));
        if (ssidStr == null || ssidStr.length() <= 0) {
            return 3;
        }
        if (this.udpClient == null) {
            this.udpClient = UdpClient.getInstance();
        }
        final String key = keyStr == null || keyStr.isEmpty() ? new String(ssidStr) : keyStr;
        this.stop = false;
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneStepWifiConfigurationManager.this.udpClient.config(OneStepWifiConfigurationManager.this.maskIpAddress, 15000, ssidStr, key, seprator, frequency, packInterval, time1, time2, time3, time4, waitTime1, waitTime2, waitTime3, waitTime4);
            }
        }).start();
        return 2;
    }

    public int startConfig(String ssidStr, String keyStr) {
        return this.startConfig(ssidStr, keyStr, 5, 200, 0, 10, 20, 10, 20, 200, 1000, 200, 1000);
    }

    public synchronized void stopConfig() {
        Log.d((String)TAG, (String)"stopSendConfigData");
        if (this.stop) {
            return;
        }
        this.stop = true;
        if (this.udpClient != null) {
            this.udpClient.stop();
        }
    }

    public void startBonjour(DeviceDiscoveryListener discoveryListener) {
        this.startBonjor(discoveryListener, true);
    }

    public void startSmartBonjour(DeviceDiscoveryListener discoveryListener) {
        this.startBonjor(discoveryListener, false);
    }

    public void stopSmartBonjour() {
        this.stopBonjour();
    }

    public void stopBonjour() {
        if (this.bonjorManage != null) {
            this.bonjorManage.stop();
            this.bonjorManage = null;
        }
    }

    private void startBonjor(DeviceDiscoveryListener discoveryListener, boolean abandonCache) {
        this.stopBonjour();
        this.bonjorManage = new BonjorManage(this.context, discoveryListener);
        this.bonjorManage.setAbandonCache(abandonCache);
        this.bonjorManage.start();
    }
}

