/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.bandwidthcheck;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.ezviz.bandwidthcheck.BWCSpeedTestResultActivity;
import com.ezviz.bandwidthcheck.R;
import com.ezviz.common.RootActivity;
import com.ezviz.common.TitleBar;
import com.videogo.bandwidthcheck.EZBWCheckManager;
import com.videogo.bandwidthcheck.EZBWCheckResult;
import com.videogo.errorlayer.ErrorInfo;
import com.videogo.exception.BaseException;
import com.videogo.openapi.EZConstants;
import com.videogo.openapi.EZOpenSDK;
import com.videogo.util.LogUtil;

public class BWCSpeedTestActivity
extends RootActivity
implements View.OnClickListener {
    private static final String TAG = BWCSpeedTestActivity.class.getSimpleName();
    private static final String EXTRA_TOKEN = "EXTRA_TOKEN";
    public static final int checkTime = 15;
    private LinearLayout deviceLL;
    private TextView deviceTv;
    private Button stopBtn;
    private RelativeLayout speedTestingRl;
    private LinearLayout speedTestFailLl;
    private TextView speedTestFailErrorTv;
    private TextView speedTestFailReasonTv;
    private Button retryBtn;
    private AlertDialog stopAlertDialog = null;
    private int bwCheckType;
    private String token;
    private String deviceSerial;
    private int cameraNo;

    public static void launch(Context context, int bwCheckType, String token, String deviceSerial, int cameraNo) {
        Intent intent = new Intent(context, BWCSpeedTestActivity.class);
        intent.putExtra("EXTRA_BWCHECK_TYPE", bwCheckType);
        intent.putExtra(EXTRA_TOKEN, token);
        intent.putExtra("com.videogo.EXTRA_DEVICE_ID", deviceSerial);
        intent.putExtra("com.videogo.EXTRA_CAMERA_NO", cameraNo);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_bwc_speed_test);
        this.initData();
        this.initTitleBar();
        this.initUI();
        this.initListener();
        new Thread(() -> this.startClientSpeedTest()).start();
    }

    public void onBackPressed() {
        if (this.speedTestingRl.getVisibility() == 0) {
            this.showStopAlertDialog();
        } else {
            super.onBackPressed();
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_stop) {
            this.showStopAlertDialog();
        } else if (v.getId() == R.id.btn_retry) {
            this.speedTestingRl.setVisibility(0);
            this.speedTestFailLl.setVisibility(8);
            new Thread(() -> this.startClientSpeedTest()).start();
        }
    }

    private void startClientSpeedTest() {
        try {
            EZOpenSDK.getInstance().startBWCheck(this.bwCheckType, this.deviceSerial, this.cameraNo, 15, this.token, new EZBWCheckManager.EZBWCheckResultCallback(){

                public void onBWCheckResult(EZBWCheckResult result) {
                    super.onBWCheckResult(result);
                    if (result.result == 0) {
                        LogUtil.i((String)TAG, (String)"startClientSpeedTest success");
                        BWCSpeedTestActivity.this.runOnUiThread(() -> {
                            if (BWCSpeedTestActivity.this.stopAlertDialog != null && BWCSpeedTestActivity.this.stopAlertDialog.isShowing()) {
                                BWCSpeedTestActivity.this.stopAlertDialog.dismiss();
                            }
                            BWCSpeedTestResultActivity.launch((Context)BWCSpeedTestActivity.this, result, true);
                            BWCSpeedTestActivity.this.finish();
                        });
                    } else {
                        BWCSpeedTestActivity.this.setSpeedTestFailedUI(result.result, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                    }
                }
            });
        }
        catch (BaseException e) {
            e.printStackTrace();
            this.runOnUiThread(() -> {
                if (e.getErrorInfo().errorCode == 400902) {
                    this.showToast("\u8d26\u53f7\u51ed\u8bc1\u5931\u6548\uff0c\u8bf7\u8054\u7cfb\u670d\u52a1\u5546\u91cd\u65b0\u63d0\u4f9b");
                    this.finish();
                } else {
                    ErrorInfo errorInfo = e.getErrorInfo();
                    this.setSpeedTestFailedUI(errorInfo.errorCode, errorInfo.description);
                }
            });
        }
    }

    private void setSpeedTestFailedUI(int errorCode, String errorReason) {
        LogUtil.e((String)TAG, (String)"startClientSpeedTest failed");
        this.runOnUiThread(() -> {
            this.speedTestFailLl.setVisibility(0);
            this.speedTestingRl.setVisibility(8);
            this.speedTestFailErrorTv.setText((CharSequence)("\u68c0\u6d4b\u5931\u8d25\uff0c\u9519\u8bef\u7801\uff1a" + errorCode));
            this.speedTestFailReasonTv.setText((CharSequence)errorReason);
        });
    }

    public void showStopAlertDialog() {
        if (this.stopAlertDialog != null && this.stopAlertDialog.isShowing()) {
            this.stopAlertDialog.dismiss();
        }
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)this);
        ViewGroup msgLayoutVg = (ViewGroup)LayoutInflater.from((Context)this.getApplicationContext()).inflate(R.layout.pop_dialog, null);
        TextView cancelTv = (TextView)msgLayoutVg.findViewById(R.id.tv_cancel);
        cancelTv.setOnClickListener(v -> this.stopAlertDialog.dismiss());
        TextView stopTv = (TextView)msgLayoutVg.findViewById(R.id.tv_stop);
        stopTv.setOnClickListener(v -> {
            EZOpenSDK.getInstance().stopBWCheck();
            this.stopAlertDialog.dismiss();
            this.finish();
        });
        dialogBuilder.setView((View)msgLayoutVg);
        dialogBuilder.setCancelable(false);
        this.stopAlertDialog = dialogBuilder.show();
    }

    private void initTitleBar() {
        TitleBar mTitleBar = (TitleBar)this.findViewById(R.id.title_bar);
        mTitleBar.setTitle(this.bwCheckType == EZConstants.EZBWCheckType.EZBWCheckClientUpward ? "\u6a21\u62df\u8bbe\u5907\u5e26\u5bbd\u68c0\u6d4b" : "\u7f51\u7edc\u6d4b\u901f");
        mTitleBar.addBackButton(v -> this.onBackPressed());
        mTitleBar.setBackgroundColor(this.getResources().getColor(R.color.transparent));
    }

    private void initData() {
        Intent intent = this.getIntent();
        this.bwCheckType = intent.getIntExtra("EXTRA_BWCHECK_TYPE", 1);
        this.token = intent.getStringExtra(EXTRA_TOKEN);
        this.deviceSerial = intent.getStringExtra("com.videogo.EXTRA_DEVICE_ID");
        this.cameraNo = intent.getIntExtra("com.videogo.EXTRA_CAMERA_NO", 1);
    }

    private void initUI() {
        this.deviceLL = (LinearLayout)this.findViewById(R.id.ll_device);
        this.deviceTv = (TextView)this.findViewById(R.id.tv_device);
        this.stopBtn = (Button)this.findViewById(R.id.btn_stop);
        this.speedTestingRl = (RelativeLayout)this.findViewById(R.id.rl_speed_testing);
        this.speedTestFailLl = (LinearLayout)this.findViewById(R.id.ll_speed_test_fail);
        this.speedTestFailErrorTv = (TextView)this.findViewById(R.id.tv_speed_test_fail_error);
        this.speedTestFailReasonTv = (TextView)this.findViewById(R.id.tv_speed_test_fail_reason);
        this.retryBtn = (Button)this.findViewById(R.id.btn_retry);
        if (!TextUtils.isEmpty((CharSequence)this.deviceSerial)) {
            this.deviceLL.setVisibility(0);
            this.deviceTv.setText((CharSequence)(this.deviceSerial + "@" + this.cameraNo));
        } else {
            this.deviceLL.setVisibility(8);
        }
    }

    private void initListener() {
        this.stopBtn.setOnClickListener((View.OnClickListener)this);
        this.retryBtn.setOnClickListener((View.OnClickListener)this);
    }
}

