/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.bandwidthcheck;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.ezviz.bandwidthcheck.BWCSpeedTestResultActivity;
import com.ezviz.bandwidthcheck.R;
import com.ezviz.common.RootActivity;
import com.ezviz.common.TitleBar;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.videogo.bandwidthcheck.EZBWCheckResult;
import com.videogo.openapi.EZConstants;
import java.util.ArrayList;
import java.util.List;

public class BWCSpeedTestNetRecordActivity
extends RootActivity {
    private static final String TAG = BWCSpeedTestNetRecordActivity.class.getSimpleName();
    private ListView listView;
    private LinearLayout noDataLL;
    private List<EZBWCheckResult> bwCheckResultList;
    private EZBWCheckNetRecordAdapter recordAdapter;
    private int bwCheckType;

    public static void launch(Context context, int bwCheckType) {
        Intent intent = new Intent(context, BWCSpeedTestNetRecordActivity.class);
        intent.putExtra("EXTRA_BWCHECK_TYPE", bwCheckType);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_bwc_speed_test_net_record);
        this.initTitleBar();
        this.initUI();
        this.initData();
    }

    private void initTitleBar() {
        TitleBar mTitleBar = (TitleBar)this.findViewById(R.id.title_bar);
        mTitleBar.setTitle("\u6d4b\u901f\u8bb0\u5f55");
        mTitleBar.addBackButton(v -> this.onBackPressed());
        mTitleBar.setBackgroundColor(this.getResources().getColor(R.color.transparent));
    }

    private void initData() {
        Intent intent = this.getIntent();
        this.bwCheckType = intent.getIntExtra("EXTRA_BWCHECK_TYPE", 1);
        String bcCheckResultKey = this.bwCheckType == EZConstants.EZBWCheckType.EZBWCheckClientUpward ? "SP_BWCHECK_RESULT_DEVICE" : "SP_BWCHECK_RESULT_CLIENT";
        SharedPreferences sp = this.getSharedPreferences("SP_BWCHECK_RESULT", 0);
        String resultsString = sp.getString(bcCheckResultKey, "");
        Gson gson = new Gson();
        this.bwCheckResultList = (List)gson.fromJson(resultsString, new TypeToken<List<EZBWCheckResult>>(){}.getType());
        if (this.bwCheckResultList == null) {
            this.noDataLL.setVisibility(0);
        } else {
            this.noDataLL.setVisibility(8);
            this.recordAdapter.setData(this.bwCheckResultList);
            this.recordAdapter.notifyDataSetChanged();
        }
    }

    private void initUI() {
        this.listView = (ListView)this.findViewById(R.id.listView);
        this.noDataLL = (LinearLayout)this.findViewById(R.id.ll_no_data);
        this.recordAdapter = new EZBWCheckNetRecordAdapter((Context)this);
        this.listView.setAdapter((ListAdapter)this.recordAdapter);
        this.listView.setOnItemClickListener((parent, view, position, id2) -> BWCSpeedTestResultActivity.launch((Context)this, this.bwCheckResultList.get(position), false));
    }

    private class EZBWCheckNetRecordAdapter
    extends BaseAdapter {
        protected List<EZBWCheckResult> mData = new ArrayList<EZBWCheckResult>();
        private LayoutInflater inflater;

        public EZBWCheckNetRecordAdapter(Context context) {
            this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        public void setData(List<EZBWCheckResult> list) {
            this.mData.clear();
            this.mData.addAll(list);
        }

        public int getCount() {
            return this.mData == null ? 0 : this.mData.size();
        }

        public Object getItem(int position) {
            return this.mData.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder = null;
            EZBWCheckResult resultInfo = this.mData.get(position);
            if (convertView == null) {
                viewHolder = new ViewHolder();
                convertView = this.inflater.inflate(R.layout.item_bwc_speed_test_net_record, parent, false);
                viewHolder.tv_title = (TextView)convertView.findViewById(R.id.text1);
                viewHolder.tv_checkTime = (TextView)convertView.findViewById(R.id.text2);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            viewHolder.tv_title.setText((CharSequence)(BWCSpeedTestNetRecordActivity.this.bwCheckType == EZConstants.EZBWCheckType.EZBWCheckClientUpward ? resultInfo.deviceSerial + "@" + resultInfo.cameraNo : resultInfo.networkName));
            viewHolder.tv_checkTime.setText((CharSequence)resultInfo.checkTime);
            return convertView;
        }

        class ViewHolder {
            TextView tv_title;
            TextView tv_checkTime;

            ViewHolder() {
            }
        }
    }
}

