/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.bandwidthcheck;

import android.annotation.TargetApi;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import com.ezviz.bandwidthcheck.R;
import com.ezviz.common.RootActivity;
import com.ezviz.common.TitleBar;
import com.ezviz.common.Utils;
import com.ezviz.sdk.configwifi.WiFiUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.hikvision.wifi.configuration.BaseUtil;
import com.videogo.bandwidthcheck.EZBWCheckResult;
import com.videogo.openapi.EZConstants;
import com.videogo.util.LocalInfo;
import com.videogo.util.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class BWCSpeedTestResultActivity
extends RootActivity
implements View.OnClickListener {
    private static final String TAG = BWCSpeedTestResultActivity.class.getSimpleName();
    public static final String EXTRA_BWC_RESULT = "EXTRA_BWC_RESULT";
    public static final String EXTRA_BWC_FROM = "EXTRA_BWC_FROM";
    private TextView resultTitleTv;
    private TextView deviceTv;
    private Button picSaveBtn;
    private LinearLayout resultLayout;
    private LinearLayout clientResultLayout;
    private TextView clientUpwardTv;
    private TextView clientDownwardTv;
    private TextView clientLossTv;
    private TextView clientLatencyTv;
    private TextView clientUpwardRefTv;
    private TextView clientDownwardRefTv;
    private LinearLayout deviceResultLayout;
    private TextView deviceUpwardTv;
    private TextView deviceLossTv;
    private TextView deviceLatencyTv;
    private TextView deviceUpwardRefTv;
    private TextView netTv;
    private TextView ispTv;
    private TextView ipTv;
    private TextView timeTv;
    private boolean isFromPermissionSetting;
    private EZBWCheckResult bwCheckResult;
    private boolean isFromSpeedTest;

    public static void launch(Context context, EZBWCheckResult result, boolean isFromSpeedTest) {
        Intent intent = new Intent(context, BWCSpeedTestResultActivity.class);
        intent.putExtra(EXTRA_BWC_RESULT, (Parcelable)result);
        intent.putExtra(EXTRA_BWC_FROM, isFromSpeedTest);
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_bwc_speed_result);
        this.initTitleBar();
        this.initData();
        this.initUI();
        if (this.isFromSpeedTest) {
            this.updateBWCheckResultCache();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isFromPermissionSetting) {
            this.checkPermissions();
            this.isFromPermissionSetting = false;
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btn_pic_save) {
            this.checkPermissions();
        }
    }

    private String getTestRefRichText(String wardString, float speed) {
        String mbpsString = Math.round(speed / 8.0f) + "M";
        String qualityString = this.getQualityText(speed);
        StringBuffer sb = new StringBuffer();
        sb.append("<font color='#2C2C2C' style='font-weight:bold'>").append(wardString).append("\u5e26\u5bbd\uff1a").append("</font>");
        sb.append("\u672c\u6b21\u6d4b\u8bd5\u7ed3\u679c\u76f8\u5f53\u4e8e ");
        sb.append("<font color='#407AFF' style='font-weight:bold'>").append(mbpsString).append("</font>");
        sb.append(" \u5e26\u5bbd\uff0c\u53ef\u4ee5\u652f\u6491");
        sb.append("<font color='#407AFF' style='font-weight:bold'>").append(qualityString).append("</font>");
        sb.append(" \u89c6\u9891\u901a\u9053").append(wardString).append("\u5bbd\u5e26");
        return sb.toString();
    }

    private String getQualityText(float speed) {
        int bandWidth = Math.round(speed / 8.0f);
        if (bandWidth < 1) {
            bandWidth = 1;
        }
        if (bandWidth <= 2) {
            return "\u6807\u6e05(480P)";
        }
        if (bandWidth <= 4) {
            return "\u9ad8\u6e05(720P)";
        }
        if (bandWidth <= 8) {
            return "\u8d85\u6e05(1080P)";
        }
        if (bandWidth <= 12) {
            return "2K";
        }
        return "4K";
    }

    private void captureAndSaveView() {
        try {
            this.resultLayout.setDrawingCacheEnabled(true);
            this.resultLayout.buildDrawingCache();
            Bitmap bitmap = Bitmap.createBitmap((Bitmap)this.resultLayout.getDrawingCache());
            this.resultLayout.setDrawingCacheEnabled(false);
            if (bitmap != null) {
                this.saveBitmapToGallery(bitmap);
            } else {
                Toast.makeText((Context)this, (CharSequence)"\u622a\u56fe\u5931\u8d25", (int)0).show();
            }
        }
        catch (Exception e) {
            LogUtil.e((String)TAG, (String)("capture view error: " + e.getMessage()));
            Toast.makeText((Context)this, (CharSequence)"\u4fdd\u5b58\u5931\u8d25", (int)0).show();
        }
    }

    private void saveBitmapToGallery(Bitmap bitmap) {
        String fileName = "\u5e26\u5bbd\u6d4b\u8bd5\u62a5\u544a_" + System.currentTimeMillis() + ".jpg";
        if (Build.VERSION.SDK_INT >= 29) {
            this.saveBitmapToMediaStore(bitmap, fileName);
        } else {
            this.saveBitmapToExternalStorage(bitmap, fileName);
        }
    }

    @RequiresApi(api=29)
    private void saveBitmapToMediaStore(Bitmap bitmap, String fileName) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("_display_name", fileName);
        contentValues.put("mime_type", "image/jpeg");
        contentValues.put("relative_path", Environment.DIRECTORY_DCIM + File.separator + Environment.DIRECTORY_SCREENSHOTS);
        Uri uri = this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
        if (uri != null) {
            try (OutputStream outputStream = this.getContentResolver().openOutputStream(uri);){
                if (bitmap.compress(Bitmap.CompressFormat.JPEG, 100, outputStream)) {
                    Toast.makeText((Context)this, (CharSequence)"\u56fe\u7247\u5df2\u4fdd\u5b58\u5230\u76f8\u518c", (int)0).show();
                }
            }
            catch (Exception e) {
                LogUtil.e((String)TAG, (String)("save to media store error: " + e.getMessage()));
                Toast.makeText((Context)this, (CharSequence)"\u4fdd\u5b58\u5931\u8d25", (int)0).show();
            }
        }
    }

    private void saveBitmapToExternalStorage(Bitmap bitmap, String fileName) {
        File picturesDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        File saveDir = new File(picturesDir, "\u5e26\u5bbd\u6d4b\u8bd5");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        File file = new File(saveDir, fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos)) {
                Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
                mediaScanIntent.setData(Uri.fromFile((File)file));
                this.sendBroadcast(mediaScanIntent);
                Toast.makeText((Context)this, (CharSequence)"\u56fe\u7247\u5df2\u4fdd\u5b58\u5230\u76f8\u518c", (int)0).show();
            }
        }
        catch (Exception e) {
            LogUtil.e((String)TAG, (String)("save to external storage error: " + e.getMessage()));
            Toast.makeText((Context)this, (CharSequence)"\u4fdd\u5b58\u5931\u8d25", (int)0).show();
        }
    }

    private void updateNetworkInfo() {
        String networkType;
        String wifiName = WiFiUtils.getCurrentWifiSsid((Context)this);
        if (!this.isValidWifiSSID(wifiName)) {
            wifiName = BaseUtil.getWifiSSID((Context)this);
        }
        String displayText = "Wi-Fi".equals(networkType = Utils.getNetworkType((Context)this)) && this.isValidWifiSSID(wifiName) ? wifiName + "(Wi-Fi)" : ("Wi-Fi".equals(networkType) ? "Wi-Fi\u7f51\u7edc" : networkType);
        this.netTv.setText((CharSequence)displayText);
    }

    private boolean isValidWifiSSID(String wifiName) {
        return !TextUtils.isEmpty((CharSequence)wifiName) && !"<unknown ssid>".equalsIgnoreCase(wifiName);
    }

    private void updateBWCheckResultCache() {
        String bcCheckResultKey = this.bwCheckResult.checkType == EZConstants.EZBWCheckType.EZBWCheckClientUpward ? "SP_BWCHECK_RESULT_DEVICE" : "SP_BWCHECK_RESULT_CLIENT";
        Gson gson = new Gson();
        SharedPreferences sp = this.getSharedPreferences("SP_BWCHECK_RESULT", 0);
        String resultsString = sp.getString(bcCheckResultKey, "");
        ArrayList<EZBWCheckResult> resultList = (ArrayList<EZBWCheckResult>)gson.fromJson(resultsString, new TypeToken<List<EZBWCheckResult>>(){}.getType());
        if (resultList == null) {
            resultList = new ArrayList<EZBWCheckResult>();
        }
        if (resultList.size() >= 20) {
            resultList.remove(resultList.size() - 1);
        }
        this.bwCheckResult.networkName = this.netTv.getText().toString();
        resultList.add(0, this.bwCheckResult);
        String jsonString = gson.toJson(resultList);
        sp.edit().putString(bcCheckResultKey, jsonString).apply();
    }

    private void initTitleBar() {
        TitleBar mTitleBar = (TitleBar)this.findViewById(R.id.title_bar);
        mTitleBar.setTitle("\u6d4b\u8bd5\u62a5\u544a");
        mTitleBar.addBackButton(v -> this.onBackPressed());
        mTitleBar.setBackgroundColor(this.getResources().getColor(R.color.transparent));
    }

    private void initData() {
        Intent intent = this.getIntent();
        if (intent.getParcelableExtra(EXTRA_BWC_RESULT) != null) {
            this.bwCheckResult = (EZBWCheckResult)intent.getParcelableExtra(EXTRA_BWC_RESULT);
            LogUtil.i((String)TAG, (String)("initData bwCheckResult = " + this.bwCheckResult));
        }
        this.isFromSpeedTest = intent.getBooleanExtra(EXTRA_BWC_FROM, false);
    }

    private void initUI() {
        this.resultTitleTv = (TextView)this.findViewById(R.id.tv_result_title);
        this.deviceTv = (TextView)this.findViewById(R.id.tv_device);
        this.picSaveBtn = (Button)this.findViewById(R.id.btn_pic_save);
        this.picSaveBtn.setOnClickListener((View.OnClickListener)this);
        this.resultLayout = (LinearLayout)this.findViewById(R.id.ll_result);
        this.clientResultLayout = (LinearLayout)this.findViewById(R.id.ll_client_result);
        this.clientUpwardTv = (TextView)this.findViewById(R.id.tv_client_upward);
        this.clientDownwardTv = (TextView)this.findViewById(R.id.tv_client_downward);
        this.clientLossTv = (TextView)this.findViewById(R.id.tv_client_loss);
        this.clientLatencyTv = (TextView)this.findViewById(R.id.tv_client_latency);
        this.clientUpwardRefTv = (TextView)this.findViewById(R.id.tv_client_upward_ref);
        this.clientDownwardRefTv = (TextView)this.findViewById(R.id.tv_client_downward_ref);
        this.deviceResultLayout = (LinearLayout)this.findViewById(R.id.ll_device_result);
        this.deviceUpwardTv = (TextView)this.findViewById(R.id.tv_device_upward);
        this.deviceLossTv = (TextView)this.findViewById(R.id.tv_device_loss);
        this.deviceLatencyTv = (TextView)this.findViewById(R.id.tv_device_latency);
        this.deviceUpwardRefTv = (TextView)this.findViewById(R.id.tv_device_upward_ref);
        this.netTv = (TextView)this.findViewById(R.id.tv_net);
        this.ispTv = (TextView)this.findViewById(R.id.tv_isp);
        this.ipTv = (TextView)this.findViewById(R.id.tv_ip);
        this.timeTv = (TextView)this.findViewById(R.id.tv_time);
        if (this.isFromSpeedTest) {
            this.updateNetworkInfo();
        } else {
            this.netTv.setText((CharSequence)this.bwCheckResult.networkName);
        }
        if ((this.bwCheckResult.checkType & EZConstants.EZBWCheckType.EZBWCheckClientUpward) > 0 && (this.bwCheckResult.checkType & EZConstants.EZBWCheckType.EZBWCheckClientDownward) > 0) {
            this.resultTitleTv.setText((CharSequence)"\u7f51\u7edc");
            this.deviceTv.setText((CharSequence)this.netTv.getText().toString());
            this.clientResultLayout.setVisibility(0);
            this.deviceResultLayout.setVisibility(8);
            this.clientUpwardTv.setText((CharSequence)String.format("%.1f", Float.valueOf(this.bwCheckResult.uploadSpeed)));
            this.clientDownwardTv.setText((CharSequence)String.format("%.1f", Float.valueOf(this.bwCheckResult.downloadSpeed)));
            this.clientLossTv.setText((CharSequence)String.format("%d", this.bwCheckResult.loss));
            this.clientLatencyTv.setText((CharSequence)String.format("%d", this.bwCheckResult.latency));
            this.clientUpwardRefTv.setText((CharSequence)Html.fromHtml((String)this.getTestRefRichText("\u4e0a\u884c", this.bwCheckResult.uploadSpeed)));
            this.clientDownwardRefTv.setText((CharSequence)Html.fromHtml((String)this.getTestRefRichText("\u4e0b\u884c", this.bwCheckResult.downloadSpeed)));
        } else {
            this.resultTitleTv.setText((CharSequence)"\u8bbe\u5907");
            this.deviceTv.setText((CharSequence)(this.bwCheckResult.deviceSerial + "@" + this.bwCheckResult.cameraNo));
            this.clientResultLayout.setVisibility(8);
            this.deviceResultLayout.setVisibility(0);
            this.deviceUpwardTv.setText((CharSequence)String.format("%.1f", Float.valueOf(this.bwCheckResult.uploadSpeed)));
            this.deviceLossTv.setText((CharSequence)String.format("%d", this.bwCheckResult.loss));
            this.deviceLatencyTv.setText((CharSequence)String.format("%d", this.bwCheckResult.latency));
            this.deviceUpwardRefTv.setText((CharSequence)Html.fromHtml((String)this.getTestRefRichText("\u4e0a\u884c", this.bwCheckResult.uploadSpeed)));
        }
        this.ispTv.setText((CharSequence)this.bwCheckResult.isp);
        this.ipTv.setText((CharSequence)this.bwCheckResult.exIp);
        this.timeTv.setText((CharSequence)this.bwCheckResult.checkTime);
    }

    public void checkPermissions() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.checkAndRequestPermission();
        } else {
            this.afterHasPermission();
        }
    }

    @TargetApi(value=23)
    private void checkAndRequestPermission() {
        ArrayList<String> lackedPermission = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 33) {
            if (this.checkSelfPermission("android.permission.READ_MEDIA_VIDEO") != 0) {
                lackedPermission.add("android.permission.READ_MEDIA_VIDEO");
            }
        } else if (Build.VERSION.SDK_INT >= 29) {
            if (this.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) {
                lackedPermission.add("android.permission.READ_EXTERNAL_STORAGE");
            }
            if (this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                lackedPermission.add("android.permission.WRITE_EXTERNAL_STORAGE");
            }
        } else if (this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            lackedPermission.add("android.permission.WRITE_EXTERNAL_STORAGE");
        }
        if (lackedPermission.size() == 0) {
            this.afterHasPermission();
        } else {
            String[] requestPermissions = new String[lackedPermission.size()];
            lackedPermission.toArray(requestPermissions);
            this.requestPermissions(requestPermissions, 1000);
        }
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 1000 && this.hasAllPermissionsGranted(grantResults)) {
            this.afterHasPermission();
        } else {
            try {
                this.showPermissionDialog();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void showPermissionDialog() {
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setMessage((CharSequence)"\u5e94\u7528\u7f3a\u5c11\u5fc5\u8981\u7684\u6743\u9650\uff01\u8bf7\u70b9\u51fb\"\u6743\u9650\"\uff0c\u6253\u5f00\u6240\u9700\u8981\u7684\u6743\u9650\u3002").setPositiveButton((CharSequence)"\u53bb\u8bbe\u7f6e", (dialog1, which) -> {
            this.isFromPermissionSetting = true;
            dialog1.dismiss();
            Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
            this.startActivity(intent);
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", (dialog12, which) -> dialog12.dismiss()).create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        dialog.getButton(-2).setTextColor(ContextCompat.getColor((Context)this, (int)R.color.black));
        Window dialogWindow = dialog.getWindow();
        WindowManager.LayoutParams p = dialogWindow.getAttributes();
        p.width = (int)((double)LocalInfo.getInstance().getScreenWidth() * 0.9);
        p.gravity = 17;
        dialogWindow.setAttributes(p);
    }

    private void afterHasPermission() {
        this.captureAndSaveView();
    }

    private boolean hasAllPermissionsGranted(int[] grantResults) {
        for (int grantResult : grantResults) {
            if (grantResult != -1) continue;
            return false;
        }
        return true;
    }
}

