/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.common;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Insets;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import android.widget.PopupWindow;
import android.widget.Toast;
import androidx.annotation.Nullable;
import com.videogo.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"Registered"})
public class RootActivity
extends Activity {
    public static final String TAG = RootActivity.class.getSimpleName();
    protected static Context mContext;
    private static List<Activity> mActivityList;
    private AlertDialog mLastDialog = null;
    private static int mNotificationId;

    protected void showToast(final int id2) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (RootActivity.this.isFinishing()) {
                    return;
                }
                String text = RootActivity.this.getString(id2);
                if (text != null && !text.equals("")) {
                    Toast.makeText((Context)mContext, (CharSequence)text, (int)1).show();
                }
            }
        });
    }

    protected void showToast(final int id2, final int errCode) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (RootActivity.this.isFinishing()) {
                    return;
                }
                String text = RootActivity.this.getString(id2);
                if (errCode != 0) {
                    int errorId = RootActivity.this.getErrorId(errCode);
                    text = errorId != 0 ? RootActivity.this.getString(errorId) : text + " (" + errCode + ")";
                }
                if (text != null && !text.equals("")) {
                    Toast.makeText((Context)mContext, (CharSequence)text, (int)1).show();
                }
            }
        });
    }

    protected void showToast(final int id2, final String msg) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (RootActivity.this.isFinishing()) {
                    return;
                }
                String text = RootActivity.this.getString(id2);
                if (!TextUtils.isEmpty((CharSequence)msg)) {
                    text = text + " (" + msg + ")";
                }
                if (text != null && !text.equals("")) {
                    Toast.makeText((Context)mContext, (CharSequence)text, (int)1).show();
                }
            }
        });
    }

    protected void showToast(CharSequence text) {
        LogUtil.d((String)TAG, (String)text.toString());
        this.runOnUiThread(() -> {
            if (this.isFinishing()) {
                return;
            }
            if (text != null && !text.equals("")) {
                Toast.makeText((Context)mContext, (CharSequence)text, (int)1).show();
            }
        });
    }

    protected int getErrorId(int errorCode) {
        int errorId = this.getResources().getIdentifier("error_code_" + errorCode, "string", this.getPackageName());
        return errorId;
    }

    protected void showToast(final int res1, final int res2, final int errCode) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                String text;
                String string2 = text = res1 != 0 ? RootActivity.this.getString(res1) : "";
                if (res2 != 0) {
                    text = text + ", " + RootActivity.this.getString(res2);
                }
                if (errCode != 0) {
                    int errorId = RootActivity.this.getErrorId(errCode);
                    text = errorId != 0 ? RootActivity.this.getString(errorId) : text + " (" + errCode + ")";
                }
                if (text != null) {
                    Toast.makeText((Context)mContext, (CharSequence)text, (int)1).show();
                }
            }
        });
    }

    protected String getErrorTip(int id2, int errCode) {
        StringBuffer errorTip = new StringBuffer();
        if (errCode != 0) {
            int errorId = this.getErrorId(errCode);
            if (errorId != 0) {
                errorTip.append(this.getString(errorId));
            } else {
                errorTip.append(this.getString(id2)).append(" (").append(errCode).append(")");
            }
        } else {
            errorTip.append(this.getString(id2));
        }
        return errorTip.toString();
    }

    protected void hideInputMethod() {
        if (this.getCurrentFocus() != null && this.getCurrentFocus().getWindowToken() != null) {
            InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
            imm.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 0);
        }
    }

    protected void removeHandler(Handler handler) {
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
            handler = null;
        }
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mContext = this;
        mActivityList.add(this);
    }

    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        this.applySystemWindowsInsets();
    }

    protected void onDestroy() {
        super.onDestroy();
        mActivityList.remove((Object)this);
    }

    private void applySystemWindowsInsets() {
        View rootView;
        if (Build.VERSION.SDK_INT >= 20 && (rootView = ((ViewGroup)this.findViewById(0x1020002)).getChildAt(0)) != null) {
            if (Build.VERSION.SDK_INT >= 30) {
                rootView.setOnApplyWindowInsetsListener((v, insets) -> {
                    Insets systemBars = insets.getInsets(WindowInsets.Type.systemBars());
                    v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
                    return insets;
                });
            } else {
                rootView.setOnApplyWindowInsetsListener((v, insets) -> {
                    v.setPadding(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
                    return insets;
                });
            }
        }
    }

    protected static int getUniqueNotificationId() {
        return mNotificationId++;
    }

    protected void initUi() {
    }

    public static void exitApp() {
        for (Activity activity : mActivityList) {
            if (activity.isFinishing()) continue;
            activity.finish();
        }
        System.exit(0);
    }

    protected void initPresenter() {
    }

    protected void dismissPopWindow(PopupWindow popupWindow) {
        if (popupWindow != null && !this.isFinishing()) {
            try {
                popupWindow.dismiss();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void measure(View view) {
        int width = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int height = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(width, height);
    }

    static {
        mActivityList = new ArrayList<Activity>();
        mNotificationId = 1;
    }

    public static interface EditTextDialogCallback {
        public void confirm(String var1);
    }
}

