/*
 * Decompiled with CFR 0.152.
 */
package com.ezviz.debug;

import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class LogFileService {
    private static final String TAG = "@@@" + LogFileService.class.getSimpleName();
    private static boolean started = false;

    public static boolean isStarted() {
        return started;
    }

    public static void start(String logFileNameWithPath) {
        Log.w((String)TAG, (String)"start()");
        final File logFile = new File(logFileNameWithPath);
        if (started) {
            Log.e((String)TAG, (String)"LogFileService has started, do not call LogFileService.start() again!");
            return;
        }
        if (logFile.isDirectory() && !logFile.delete()) {
            Log.e((String)TAG, (String)"logFile exist, but is a directory!");
            return;
        }
        File logFileFolder = logFile.getParentFile();
        boolean exist = logFileFolder.exists();
        if (!exist) {
            exist = logFileFolder.mkdirs();
        }
        if (!exist) {
            Log.e((String)TAG, (String)"logFileFolder can not be created!");
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                started = true;
                try {
                    int currentPid = android.os.Process.myPid();
                    Log.w((String)TAG, (String)("save log of pid(" + currentPid + ") to log file(" + logFile.getPath() + ")"));
                    String logcatCommand = "logcat | grep \"(" + currentPid + ")\"";
                    Log.w((String)TAG, (String)("logcatCommand is: " + logcatCommand));
                    Process process = Runtime.getRuntime().exec(logcatCommand);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()), 1024);
                    FileOutputStream fos = new FileOutputStream(logFile, true);
                    Log.w((String)TAG, (String)"start to write log");
                    while (started) {
                        String line = bufferedReader.readLine();
                        if (line == null) continue;
                        fos.write((line + "\n").getBytes());
                        fos.flush();
                    }
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static void stop() {
        Log.w((String)TAG, (String)"stop()");
        if (started) {
            started = false;
            Log.w((String)TAG, (String)"stop to write log");
        }
    }
}

