package ezviz.ezopensdkcommon.common;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Insets;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.PopupWindow;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

import ezviz.ezopensdkcommon.R;

@SuppressLint("Registered")
public class RootActivity extends Activity {

    public final static String TAG = RootActivity.class.getSimpleName();

    protected static Context mContext;

    private WaitDialog mWaitDlg;

    protected void showToast(final int id) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (isFinishing()) {
                    return;
                }
                String text = getString(id);
                if (text != null && !text.equals("")) {
                    Toast.makeText(mContext, text, Toast.LENGTH_LONG).show();
                }
            }
        });
    }

    protected void showToast(final int id, final int errCode) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (isFinishing()) {
                    return;
                }

                String text = getString(id);
                if (errCode != 0) {
                    int errorId = getErrorId(errCode);
                    if (errorId != 0) {
                        text = getString(errorId);
                    } else {
                        text = text + " (" + errCode + ")";
                    }
                }
                if (text != null && !text.equals("")) {
                    Toast.makeText(mContext, text, Toast.LENGTH_LONG).show();
                }
            }
        });

    }

    protected void showToast(final int id, final String msg) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (isFinishing()) {
                    return;
                }

                String text = getString(id);
                if (!TextUtils.isEmpty(msg)) {
                    text = text + " (" + msg + ")";
                }
                if (text != null && !text.equals("")) {
                    Toast.makeText(mContext, text, Toast.LENGTH_LONG).show();
                }
            }
        });
    }

    protected void showToast(final CharSequence text) {
        LogUtil.d(TAG, text.toString());
        runOnUiThread(() -> {
            if (isFinishing()) {
                return;
            }
            if (text != null && !text.equals("")) {
                Toast.makeText(mContext, text, Toast.LENGTH_LONG).show();
            }
        });
    }

    protected int getErrorId(int errorCode) {
        int errorId = this.getResources().getIdentifier("error_code_" + errorCode, "string", this.getPackageName());
        /*
         * Field fieldError; int errorId = 0; try { fieldError =
         * R.string.class.getDeclaredField("error_code_" + errorCode);
         * fieldError.setAccessible(true); R.string string = new R.string(); try { errorId =
         * fieldError.getInt(string); } catch (IllegalAccessException e) { // TODO Auto-generated
         * catch block e.printStackTrace(); } catch (IllegalArgumentException e) { // TODO
         * Auto-generated catch block e.printStackTrace(); } } catch (NoSuchFieldException e) { //
         * TODO Auto-generated catch block e.printStackTrace(); }
         */

        return errorId;
    }

    protected void showToast(final int res1, final int res2, final int errCode) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                String text = res1 != 0 ? getString(res1) : "";
                if (res2 != 0) {
                    text = text + ", " + getString(res2);
                }
                if (errCode != 0) {
                    int errorId = getErrorId(errCode);
                    if (errorId != 0) {
                        text = getString(errorId);
                    } else {
                        text = text + " (" + errCode + ")";
                    }
                }
                if (text != null) {
                    Toast.makeText(mContext, text, Toast.LENGTH_LONG).show();
                }
            }
        });
    }

    protected void showWaitDialog(String content) {
        mWaitDlg = new WaitDialog(this, android.R.style.Theme_Translucent_NoTitleBar);
        if (content != null && !content.equals("")) {
            mWaitDlg.setWaitText(content);
        }
        mWaitDlg.setCancelable(false);
        mWaitDlg.show();
    }

    protected void showWaitDialog(int resId) {
        mWaitDlg = new WaitDialog(this, android.R.style.Theme_Translucent_NoTitleBar);
        mWaitDlg.setWaitText(getString(resId));
        mWaitDlg.setCancelable(false);
        mWaitDlg.show();
    }

    public void showWaitDialog() {
        mWaitDlg = new WaitDialog(this, android.R.style.Theme_Translucent_NoTitleBar);
        mWaitDlg.setCancelable(false);
        mWaitDlg.show();
    }

    public void showCancelableWaitDialog() {
        mWaitDlg = new WaitDialog(this, android.R.style.Theme_Translucent_NoTitleBar);
        mWaitDlg.setCancelable(true);
        mWaitDlg.show();
    }

    public boolean isDialogShowing() {
        if (mWaitDlg != null && mWaitDlg.isShowing()) {
            return true;
        } else {
            return false;
        }
    }

    public void dismissWaitDialog() {
        if (mWaitDlg != null && mWaitDlg.isShowing()) {
            mWaitDlg.dismiss();
        }
    }

    protected String getErrorTip(int id, int errCode) {
        StringBuffer errorTip = new StringBuffer();

        if (errCode != 0) {
            int errorId = getErrorId(errCode);
            if (errorId != 0) {
                errorTip.append(getString(errorId));
            } else {
                errorTip.append(getString(id)).append(" (").append(errCode).append(")");
            }
        } else {
            errorTip.append(getString(id));
        }
        return errorTip.toString();
    }

    protected void hideInputMethod() {
        if (getCurrentFocus() != null && getCurrentFocus().getWindowToken() != null) {
            InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(getCurrentFocus().getWindowToken(), 0);
        }
    }

    protected void removeHandler(Handler handler) {
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
            handler = null;
        }
    }

    private static List<Activity> mActivityList = new ArrayList<>();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mContext = this;
        mActivityList.add(this);
    }


    @Override
    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        applySystemWindowsInsets();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mActivityList.remove(this);
    }

    private void applySystemWindowsInsets() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT_WATCH) {
            final View rootView = ((ViewGroup) findViewById(android.R.id.content)).getChildAt(0);
            if (rootView != null) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
                    rootView.setOnApplyWindowInsetsListener((v, insets) -> {
                        Insets systemBars = insets.getInsets(WindowInsets.Type.systemBars());
                        v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
                        return insets;
                    });
                } else {
                    rootView.setOnApplyWindowInsetsListener((v, insets) -> {
                        v.setPadding(
                                insets.getSystemWindowInsetLeft(),
                                insets.getSystemWindowInsetTop(),
                                insets.getSystemWindowInsetRight(),
                                insets.getSystemWindowInsetBottom()
                        );
                        return insets;
                    });
                }
            }
        }
    }

    private AlertDialog mLastDialog = null;

    protected void dialog(final String title, final String msg) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (mLastDialog != null && mLastDialog.isShowing()) {
                    mLastDialog.dismiss();
                }
                AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(RootActivity.this);
                dialogBuilder.setTitle(title);
                ViewGroup msgLayoutVg =
                        (ViewGroup) LayoutInflater.from(getApplicationContext()).inflate(R.layout.layout_dialog_tip,
                                null);
                TextView msgTv = (TextView) msgLayoutVg.findViewById(R.id.tv_tip);
                if (msgTv != null) {
                    msgTv.setText(msg);
                }
                dialogBuilder.setView(msgLayoutVg);
                dialogBuilder.setPositiveButton(getApplicationContext().getString(R.string.btn_ensure),
                        new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialog, int which) {
                                dialog.dismiss();
                            }
                        });
                dialogBuilder.setCancelable(false);
                mLastDialog = dialogBuilder.show();
            }
        });
    }

    /**
     * 复制弹出框
     */
    protected void copyDialog(final String title, final String resString) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                AlertDialog.Builder copyDialog = new AlertDialog.Builder(RootActivity.this);
                copyDialog.setTitle(title);
                copyDialog.setMessage(resString);
                copyDialog.setPositiveButton("Copy", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        // 获取剪贴版
                        ClipboardManager clipboard = (ClipboardManager) getSystemService(Context.CLIPBOARD_SERVICE);
                        ClipData clip = ClipData.newPlainText("text", resString);
                        clipboard.setPrimaryClip(clip);
                        Toast.makeText(getApplicationContext(), getString(R.string.copied_to_clipboard),
                                Toast.LENGTH_LONG).show();
                    }
                });
                copyDialog.show();
            }
        });
    }

    public interface EditTextDialogCallback {
        public void confirm(String value);
    }

    protected void dialogWithEditText(final String title, final EditTextDialogCallback callback) {
        AlertDialog.Builder builder = new AlertDialog.Builder(RootActivity.this);
        builder.setTitle(title);

        final EditText editText = new EditText(RootActivity.this);
        builder.setView(editText);

        builder.setPositiveButton(R.string.confirm, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                String inputText = editText.getText().toString();
                if (TextUtils.isEmpty(inputText)) {
                    showToast("请输入内容");
                    return;
                }
                if (callback != null) {
                    callback.confirm(inputText);
                }
            }
        });
        builder.setNegativeButton(R.string.cancel, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    private static int mNotificationId = 1;

    protected static int getUniqueNotificationId() {
        return mNotificationId++;
    }

    protected void initUi() {
    }

    private static TaskManager mTaskManager = null;

    protected synchronized static TaskManager getTaskManager() {
        if (mTaskManager == null) {
            mTaskManager = new TaskManager();
        }
        return mTaskManager;
    }

    public static void exitApp() {
        for (Activity activity : mActivityList) {
            if (!activity.isFinishing()) {
                activity.finish();
            }
        }
        System.exit(0);
    }

    protected void initPresenter() {
    }

    protected void dismissPopWindow(PopupWindow popupWindow) {
        if (popupWindow != null && !isFinishing()) {
            try {
                popupWindow.dismiss();
            } catch (Exception e) {
                // TODO: handle exception
            }
        }
    }

    protected void measure(View view) {
        int width = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);
        int height = View.MeasureSpec.makeMeasureSpec(0, View.MeasureSpec.UNSPECIFIED);
        view.measure(width, height);
    }

}
